/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

#define	SPEED 		.25
#define	STAR_NUMBER 200
#define	ITER 		4

vec3 col1 = vec3(155., 176., 255.) / 256.; // Coolest star color
vec3 col2 = vec3(255., 204., 111.) / 256.; // Hottest star color

float rand(float i)
{
    return fract(sin(dot(vec2(i, i) ,vec2(32.9898,78.233))) * 43758.5453);
}

void main ( void )
{
	vec2 uv = gl_FragCoord.xy / iResolution.y;
    float res = iResolution.x / iResolution.y;

    gl_FragColor = vec4(0.0);
    
    // static far stars
    
   	vec4 sStar = vec4(rand(uv.x * uv.y));
    
    sStar *= pow(rand(uv.x * uv.y), 200.);
    sStar.xyz *= mix(col1, col2, rand(uv.x + uv.y));
    
    gl_FragColor += sStar;
    
    // milky way (work in progress)
    
    vec4 col = 0.5 - vec4(length(vec2(uv.x, 0.5) - uv));
    col.xyz *= mix(col1, col2, 0.75);

    gl_FragColor += col * 2.;
    
    vec4 c = vec4(0.);
    vec4 c2 = vec4(0.);
    
    vec2 rv = uv;
    rv.x -= iGlobalTime * SPEED * 0.25;
    
    for(int i=0;i<ITER;i++)
		c += texture2D(iChannel0, rv * 0.25 + rand(float(i + 10) + uv.x * uv.y) * (16. / iResolution.y)) / float(ITER);
    
    gl_FragColor -= c * 0.5;
    
    gl_FragColor = clamp(gl_FragColor, 0.0, 1.0);
    
    // Dynamic Stars
    
    for (int i = 0; i < STAR_NUMBER; ++i)
    {
    	float n = float(i);
        
        //position of the star
        vec3 pos = vec3(rand(n) * res + iGlobalTime * SPEED, rand(n + 1.) , rand(n + 2.));
        
        // parralax effect
        pos.x = mod(pos.x * pos.z, res);
        
        pos.y = (pos.y + rand(n + 10.)) * 0.5;

        //drawing the star
        vec4 col = vec4(pow(length(pos.xy - uv), -1.25) * 0.001 * pos.z * rand(n + 3.));
        
        //coloring the star
        col.xyz *= mix(col1, col2, rand(n + 4.));
        
        //star flickering
        col.xyz *= mix(rand(n + 5.), 1.0, abs(cos(iGlobalTime * rand(n + 6.) * 5.)));
        
        gl_FragColor += vec4(col);
    }
    
}